---------------------------------------------------------------------------
-- Spellsteal Monitor
-- Creates a small frame with stealable spells from your current target.
-- Blinddate (Us-Thrall)
-- Alfabravo (US-Manoroth)
-- Iniitial release commit 01/16/10
-- 1.2.. Compatible with Cataclysm, frame autosizes to number of stealable buffs, click frame to cast spellsteal.
-- 1.1 -- .toc bump. 
---------- Thanks to b_buck (@Curse) creator of MageNuggets for the inspiration and some of the code used in this  :)
---------------------------------------------------------------------------
local version = GetAddOnMetadata("Spellstealer", "Version")


SSFrame = nil
SSFrameList = nil
local debug = false

function SS_OnLoad(self)
	if not self then
		self = this
	end
	self:RegisterEvent("PLAYER_TARGET_CHANGED")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterEvent("UNIT_AURA")
	self:RegisterEvent("PLAYER_DEAD")
	SSFrameCreate()
	SSFrameUpdate()
end

function SSFrameUpdate()
	local  i = 1
	local stealableBuffs = { }
	local buffName, _, _, _, _, _, _, _, isStealable = UnitAura("target", i, "HELPFUL")
	
	while buffName do
		if (isStealable == 1) then
			stealableBuffs[#stealableBuffs +1] = buffName
		end
		i = i+1
		buffName, _, _, _, _, _, _, _, isStealable = UnitAura("target", i, "HELPFUL")
	end
	if (debug == true) then
		stealableBuffs[1] = "Steal me!"
		stealableBuffs[2] = "Me too!!"
		stealableBuffs[3] = "What about me??"
	end
		
	if (#stealableBuffs<1) then
		SSFrame:Hide()
	else
		
		local height = 10* #stealableBuffs
		stealableBuffs = table.concat(stealableBuffs, "\n")
		SSFrameList:SetHeight(height)
		SSFrameList.DisplayText:SetText(stealableBuffs)
		SSFrame:Show()
	end
end

function SS_handleEvent(self, event, ...)
	--DEFAULT_CHAT_FRAME:AddMessage(event..arg1)
	
	if (event == "PLAYER_TARGET_CHANGED") then
		SSFrameUpdate()
	elseif (event == "PLAYER_DEAD") then
		SSFrameUpdate()
	elseif (event == "COMBAT_LOG_EVENT_UNFILTERED")	 then
		local cEvent, sourceGUID, sourceName, _, destGUID, destName, _ = select(2, ...)
		local spellID = select(12,...)
		
		if (cEvent == "SPELL_STOLEN" and sourceGUID == UnitGUID("player")) then
			if(GetCVar("enableCombatText") == '1') then
				CombatText_AddMessage("Stole:"..GetSpellLink(spellID), CombatText_StandardScroll, 0.10, 0, 1, "sticky", nil);
			end
			DEFAULT_CHAT_FRAME:AddMessage("|cffFFFFFFYou have stolen:"..GetSpellLink(spellID).." from "..destName)
	    	end
	elseif (event == "UNIT_AURA" and select(1,...) == "target") then
		
		SSFrameUpdate()
	end
end


function SSFrameCreate()
   
	local backdrop = {bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 3, left=2, right=2, top=2, bottom=2}
	
	if not SSFrame then
		SSFrame = CreateFrame("Frame", "SSFrame", UIParent)
		SSFrame:SetClampedToScreen(true)
		SSFrame:SetFrameStrata("HIGH")
		SSFrame:SetBackdrop(backdrop)
		SSFrame:SetBackdropColor(0,0,0,1)
		SSFrame:SetWidth(220)
		SSFrame:SetHeight(20) 
		SSFrame:SetPoint("CENTER",0,0)
		SSFrame:EnableMouse(true)
		SSFrame:SetMovable(true)
		SSFrame:RegisterForDrag("RightButton")
		SSFrame:SetUserPlaced(true)
		
		SSFrame:SetScript('OnMouseDown', function(self) 
			self:StartMoving()
			self.IsMoving = true
		end)
		SSFrame:SetScript('OnMouseUp', function(self)
			self:StopMovingOrSizing()
			self.IsMoving = false
		end)
		SSFrame:SetScript("OnShow", function(self)
			SSFrameList:Show()
			end)
		
		SSFrametitle = SSFrame:CreateFontString("SSFrametitletext", "OVERLAY")
		SSFrametitle:SetFont("Fonts\\FRIZQT__.TTF", 12)
		SSFrametitle:SetJustifyH("LEFT")
		SSFrametitle:SetText("Spell Stealer")
		SSFrametitle:SetPoint("TOPLEFT", 0, -4)
		
		SSFrameList = CreateFrame("Button", "SSFrameList", SSFrame,"SecureActionButtonTemplate")
		SSFrameList:SetFrameStrata("HIGH")
		SSFrameList:SetPoint("TOPLEFT",0,-21)
		SSFrameList:SetWidth(220)
		SSFrameList:SetHeight(80)
		SSFrameList:SetBackdrop(backdrop)
		SSFrameList:SetBackdropColor(1,0,0,.5)
		SSFrameList:SetBackdropBorderColor(0,0,0)
		SSFrameList.elapsed = 0
		SSFrameList.DisplayText = SSFrameList:CreateFontString("SSFrameListText", "OVERLAY", SSFrameList)
		SSFrameList.DisplayText:SetFont("Fonts\\FRIZQT__.TTF", 10)
		SSFrameList.DisplayText:SetJustifyH("LEFT")
		SSFrameList.DisplayText:SetPoint("LEFT")
		--SSFrameList:RegisterForClicks("AnyUp");
--		local name, rank, texture, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo("Spellsteal");

		SSFrameList:SetAttribute("type", "spell");
		SSFrameList:SetAttribute("spell", "Spellsteal");
	end
end

